/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSTransformValue.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebKitCSSTransformValueOperationType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebKitCSSTransformValuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebKitCSSTransformValuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitCSSTransformValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitCSSTransformValuePrototype>(vm.heap)) JSWebKitCSSTransformValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitCSSTransformValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebKitCSSTransformValue> JSWebKitCSSTransformValueConstructor;

/* Hash table for constructor */

static const HashTableValue JSWebKitCSSTransformValueConstructorTableValues[] =
{
    { "CSS_TRANSLATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_TRANSLATEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_TRANSLATEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_ROTATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_SCALE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_SCALEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_SCALEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_SKEW", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_SKEWX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_SKEWY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_MATRIX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_TRANSLATEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_TRANSLATE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_ROTATEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_ROTATEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_ROTATEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_ROTATE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_SCALEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_SCALE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_PERSPECTIVE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_MATRIX3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(21) } },
};

template<> JSValue JSWebKitCSSTransformValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSValueList::getConstructor(vm, &globalObject);
}

template<> void JSWebKitCSSTransformValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitCSSTransformValue::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebKitCSSTransformValue"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSWebKitCSSTransformValueConstructorTableValues, *this);
}

template<> const ClassInfo JSWebKitCSSTransformValueConstructor::s_info = { "WebKitCSSTransformValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSTransformValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSTransformValuePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSTransformValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSTransformValueConstructor) } },
    { "operationType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSTransformValueOperationType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "CSS_TRANSLATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_TRANSLATEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_TRANSLATEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_ROTATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_SCALE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_SCALEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_SCALEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_SKEW", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_SKEWX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_SKEWY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_MATRIX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_TRANSLATEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_TRANSLATE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_ROTATEX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_ROTATEY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_ROTATEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_ROTATE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_SCALEZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_SCALE3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_PERSPECTIVE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_MATRIX3D", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(21) } },
};

const ClassInfo JSWebKitCSSTransformValuePrototype::s_info = { "WebKitCSSTransformValuePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSTransformValuePrototype) };

void JSWebKitCSSTransformValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitCSSTransformValuePrototypeTableValues, *this);
}

const ClassInfo JSWebKitCSSTransformValue::s_info = { "WebKitCSSTransformValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSTransformValue) };

JSWebKitCSSTransformValue::JSWebKitCSSTransformValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitCSSTransformValue>&& impl)
    : JSCSSValueList(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebKitCSSTransformValue::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebKitCSSTransformValuePrototype::create(vm, globalObject, JSWebKitCSSTransformValuePrototype::createStructure(vm, globalObject, JSCSSValueList::getPrototype(vm, globalObject)));
}

JSObject* JSWebKitCSSTransformValue::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSTransformValue>(vm, globalObject);
}

bool JSWebKitCSSTransformValue::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSWebKitCSSTransformValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSWebKitCSSTransformValue::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSWebKitCSSTransformValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsWebKitCSSTransformValueOperationType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSTransformValue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSTransformValue", "operationType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.operationType());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSTransformValueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebKitCSSTransformValuePrototype* domObject = jsDynamicCast<JSWebKitCSSTransformValuePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebKitCSSTransformValue::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebKitCSSTransformValueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebKitCSSTransformValuePrototype* domObject = jsDynamicCast<JSWebKitCSSTransformValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSWebKitCSSTransformValue::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSWebKitCSSTransformValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSWebKitCSSTransformValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSTransformValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
