/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathException.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathExceptionPrototypeFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXPathExceptionCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathExceptionName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathExceptionMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathExceptionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXPathExceptionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXPathExceptionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXPathExceptionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathExceptionPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathExceptionPrototype>(vm.heap)) JSXPathExceptionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathExceptionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSXPathException> JSXPathExceptionConstructor;

/* Hash table */

static const struct CompactHashIndex JSXPathExceptionTableIndex[9] = {
    { -1, -1 },
    { 0, 8 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 1, -1 },
};


static const HashTableValue JSXPathExceptionTableValues[] =
{
    { "code", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "message", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSXPathExceptionTable = { 3, 7, true, JSXPathExceptionTableValues, JSXPathExceptionTableIndex };
/* Hash table for constructor */

static const HashTableValue JSXPathExceptionConstructorTableValues[] =
{
    { "INVALID_EXPRESSION_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(51) } },
    { "TYPE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(52) } },
};

template<> JSValue JSXPathExceptionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathExceptionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXPathException::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XPathException"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSXPathExceptionConstructorTableValues, *this);
}

template<> const ClassInfo JSXPathExceptionConstructor::s_info = { "XPathException", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathExceptionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXPathExceptionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXPathExceptionConstructor) } },
    { "toString", DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathExceptionPrototypeFunctionToString), (intptr_t) (0) } },
    { "INVALID_EXPRESSION_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(51) } },
    { "TYPE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(52) } },
};

const ClassInfo JSXPathExceptionPrototype::s_info = { "XPathExceptionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathExceptionPrototype) };

void JSXPathExceptionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathExceptionPrototypeTableValues, *this);
}

const ClassInfo JSXPathException::s_info = { "XPathException", &Base::s_info, &JSXPathExceptionTable, CREATE_METHOD_TABLE(JSXPathException) };

JSXPathException::JSXPathException(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathException>&& impl)
    : JSDOMWrapper<XPathException>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXPathException::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXPathExceptionPrototype::create(vm, globalObject, JSXPathExceptionPrototype::createStructure(vm, globalObject, globalObject->errorPrototype()));
}

JSObject* JSXPathException::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathException>(vm, globalObject);
}

void JSXPathException::destroy(JSC::JSCell* cell)
{
    JSXPathException* thisObject = static_cast<JSXPathException*>(cell);
    thisObject->JSXPathException::~JSXPathException();
}

bool JSXPathException::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSXPathException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSXPathException, Base>(state, JSXPathExceptionTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsXPathExceptionCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXPathException*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XPathException", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.code());
    return JSValue::encode(result);
}


EncodedJSValue jsXPathExceptionName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXPathException*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XPathException", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsXPathExceptionMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXPathException*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XPathException", "message");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.message());
    return JSValue::encode(result);
}


EncodedJSValue jsXPathExceptionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXPathExceptionPrototype* domObject = jsDynamicCast<JSXPathExceptionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXPathException::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXPathExceptionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXPathExceptionPrototype* domObject = jsDynamicCast<JSXPathExceptionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXPathException::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathExceptionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathExceptionPrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathException*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathException", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathException::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

bool JSXPathExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathException = jsCast<JSXPathException*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathException->wrapped(), jsXPathException);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathException* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXPathException>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathException* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathException>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathException.
    COMPILE_ASSERT(!__is_polymorphic(XPathException), XPathException_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSXPathException>(globalObject, impl);
}

XPathException* JSXPathException::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathException*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
