/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathExpression.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSXPathResult.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathExpressionPrototypeFunctionEvaluate(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXPathExpressionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXPathExpressionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXPathExpressionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXPathExpressionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathExpressionPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathExpressionPrototype>(vm.heap)) JSXPathExpressionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathExpressionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSXPathExpression> JSXPathExpressionConstructor;

template<> JSValue JSXPathExpressionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathExpressionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXPathExpression::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XPathExpression"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXPathExpressionConstructor::s_info = { "XPathExpression", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathExpressionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXPathExpressionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExpressionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXPathExpressionConstructor) } },
    { "evaluate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathExpressionPrototypeFunctionEvaluate), (intptr_t) (0) } },
};

const ClassInfo JSXPathExpressionPrototype::s_info = { "XPathExpressionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathExpressionPrototype) };

void JSXPathExpressionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathExpressionPrototypeTableValues, *this);
}

const ClassInfo JSXPathExpression::s_info = { "XPathExpression", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathExpression) };

JSXPathExpression::JSXPathExpression(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathExpression>&& impl)
    : JSDOMWrapper<XPathExpression>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXPathExpression::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXPathExpressionPrototype::create(vm, globalObject, JSXPathExpressionPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSXPathExpression::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathExpression>(vm, globalObject);
}

void JSXPathExpression::destroy(JSC::JSCell* cell)
{
    JSXPathExpression* thisObject = static_cast<JSXPathExpression*>(cell);
    thisObject->JSXPathExpression::~JSXPathExpression();
}

EncodedJSValue jsXPathExpressionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXPathExpressionPrototype* domObject = jsDynamicCast<JSXPathExpressionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXPathExpression::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXPathExpressionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXPathExpressionPrototype* domObject = jsDynamicCast<JSXPathExpressionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXPathExpression::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathExpressionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathExpressionPrototypeFunctionEvaluate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathExpression*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathExpression", "evaluate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathExpression::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* contextNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    uint16_t type = toUInt16(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    XPathResult* inResult = JSXPathResult::toWrapped(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.evaluate(contextNode, type, inResult, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSXPathExpressionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathExpressionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathExpression = jsCast<JSXPathExpression*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathExpression->wrapped(), jsXPathExpression);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathExpression* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXPathExpression>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathExpression* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathExpression>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathExpression.
    COMPILE_ASSERT(!__is_polymorphic(XPathExpression), XPathExpression_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSXPathExpression>(globalObject, impl);
}

XPathExpression* JSXPathExpression::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathExpression*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
