/*
 * Copyright (c) 2015 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamReaderBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamReaderCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamReaderCancelCodeLength = 399;
const char* s_readableStreamReaderCancelCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamReader(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"Function should be called on a ReadableStreamReader\"));\n" \
    "    if (!this.@ownerReadableStream)\n" \
    "        return @Promise.@reject(new @TypeError(\"cancel() called on a reader owned by no readable stream\"));\n" \
    "    return @cancelReadableStream(this.@ownerReadableStream, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamReaderReadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamReaderReadCodeLength = 370;
const char* s_readableStreamReaderReadCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamReader(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"Function should be called on a ReadableStreamReader\"));\n" \
    "    if (!this.@ownerReadableStream)\n" \
    "        return @Promise.@reject(new @TypeError(\"read() called on a reader owned by no readable stream\"));\n" \
    "    return @readFromReadableStreamReader(this);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamReaderReleaseLockCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamReaderReleaseLockCodeLength = 756;
const char* s_readableStreamReaderReleaseLockCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamReader(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStreamReader\");\n" \
    "    const stream = this.@ownerReadableStream;\n" \
    "    if (!stream)\n" \
    "         return;\n" \
    "    if (this.@readRequests.length)\n" \
    "        throw new @TypeError(\"There are still pending read requests, cannot release the lock\");\n" \
    "    if (stream.@state === @streamReadable)\n" \
    "        this.@closedPromiseCapability.@reject.@call(@undefined, new @TypeError(\"releasing lock of reader whose stream is still in readable state\"));\n" \
    "    else\n" \
    "        this.@closedPromiseCapability = { @promise: @Promise.@reject(new @TypeError(\"reader released lock\")) };\n" \
    "    stream.@reader = @undefined;\n" \
    "    this.@ownerReadableStream = null;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamReaderClosedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamReaderClosedCodeLength = 226;
const char* s_readableStreamReaderClosedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamReader(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"Callee of closed is not a ReadableStreamReader\"));\n" \
    "    return this.@closedPromiseCapability.@promise;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamReaderBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().readableStreamReaderBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_READABLESTREAMREADER_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
