/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#ifndef WritableStreamInternalsBuiltins_h
#define WritableStreamInternalsBuiltins_h

#if ENABLE(STREAMS_API)

#include <builtins/BuiltinUtils.h>
#include <bytecode/UnlinkedFunctionExecutable.h>
#include <runtime/Identifier.h>
#include <runtime/JSFunction.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* WritableStreamInternals */
extern const char* s_writableStreamInternalsIsWritableStreamCode;
extern const int s_writableStreamInternalsIsWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamCodeConstructAbility;
extern const char* s_writableStreamInternalsSyncWritableStreamStateWithQueueCode;
extern const int s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeConstructAbility;
extern const char* s_writableStreamInternalsErrorWritableStreamCode;
extern const int s_writableStreamInternalsErrorWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsErrorWritableStreamCodeConstructAbility;
extern const char* s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCode;
extern const int s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeConstructAbility;
extern const char* s_writableStreamInternalsWritableStreamAdvanceQueueCode;
extern const int s_writableStreamInternalsWritableStreamAdvanceQueueCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAdvanceQueueCodeConstructAbility;
extern const char* s_writableStreamInternalsCloseWritableStreamCode;
extern const int s_writableStreamInternalsCloseWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsCloseWritableStreamCodeConstructAbility;

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(isWritableStream, writableStreamInternalsIsWritableStream, 1) \
    macro(syncWritableStreamStateWithQueue, writableStreamInternalsSyncWritableStreamStateWithQueue, 1) \
    macro(errorWritableStream, writableStreamInternalsErrorWritableStream, 2) \
    macro(callOrScheduleWritableStreamAdvanceQueue, writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueue, 1) \
    macro(writableStreamAdvanceQueue, writableStreamInternalsWritableStreamAdvanceQueue, 1) \
    macro(closeWritableStream, writableStreamInternalsCloseWritableStream, 1) \

#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ISWRITABLESTREAM 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_SYNCWRITABLESTREAMSTATEWITHQUEUE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ERRORWRITABLESTREAM 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_CALLORSCHEDULEWRITABLESTREAMADVANCEQUEUE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMADVANCEQUEUE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_CLOSEWRITABLESTREAM 1

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(writableStreamInternalsIsWritableStreamCode, isWritableStream, s_writableStreamInternalsIsWritableStreamCodeLength) \
    macro(writableStreamInternalsSyncWritableStreamStateWithQueueCode, syncWritableStreamStateWithQueue, s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeLength) \
    macro(writableStreamInternalsErrorWritableStreamCode, errorWritableStream, s_writableStreamInternalsErrorWritableStreamCodeLength) \
    macro(writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCode, callOrScheduleWritableStreamAdvanceQueue, s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeLength) \
    macro(writableStreamInternalsWritableStreamAdvanceQueueCode, writableStreamAdvanceQueue, s_writableStreamInternalsWritableStreamAdvanceQueueCodeLength) \
    macro(writableStreamInternalsCloseWritableStreamCode, closeWritableStream, s_writableStreamInternalsCloseWritableStreamCodeLength) \

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(callOrScheduleWritableStreamAdvanceQueue) \
    macro(closeWritableStream) \
    macro(errorWritableStream) \
    macro(isWritableStream) \
    macro(syncWritableStreamStateWithQueue) \
    macro(writableStreamAdvanceQueue) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class WritableStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit WritableStreamInternalsBuiltinsWrapper(JSC::VM* vm)
        : m_vm(*vm)
        WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length)))
        WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, length) \
inline JSC::UnlinkedFunctionExecutable* WritableStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable)\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, functionName##PublicName(), s_##name##ConstructAbility), this, &m_##name##Executable);\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void WritableStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class WritableStreamInternalsBuiltinFunctions {
public:
    explicit WritableStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    void visit(JSC::SlotVisitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void WritableStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::createBuiltinFunction(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

inline void WritableStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(&m_##name##Function);
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}


} // namespace WebCore

#endif // ENABLE(STREAMS_API)

#endif // WritableStreamInternalsBuiltins_h
