import type {SidebarsConfig} from '@docusaurus/plugin-content-docs';

/**
 * Creating a sidebar enables you to:
 - create an ordered group of docs
 - render a sidebar for each doc of that group
 - provide next/previous navigation

 The sidebars can be generated from the filesystem, or explicitly defined here.

 Create as many sidebars as you want.
 */
const sidebars: SidebarsConfig = {
  // By default, Docusaurus generates a sidebar from the docs folder structure
  gettingStarted: [{type: `autogenerated`, dirName: `getting-started`}],
  advanced: [{type: `autogenerated`, dirName: `advanced`}],
  features: [{type: `autogenerated`, dirName: `features`}],
  configuration: [{type: `autogenerated`, dirName: `configuration`}],
};

// eslint-disable-next-line arca/no-default-export
export default sidebars;
